/*
 * @(#)ActivityModel.java  1.0  2006-03-20
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.am.model;

import ch.hslu.cm.simulation.*;
import org.jhotdraw.util.ResourceBundleUtil;

/**
 * Holds an Activity Model (without its graphical representation).
 *
 * @author Werner Randelshofer, Florian Padrun
 * @version 1.0 2006-03-20 Created.
 */
public class ActivityModel extends AbstractSimulation {
    public static ResourceBundleUtil labels
            = ResourceBundleUtil.getBundle("ch.hslu.cm.am.Labels");
    
    /** Enumeration of simulated concepts. */
    public final static int INITIAL_NODE = 0;
    public final static int CONTROL_FLOW = 1;
    public final static int ACTION = 2;
    public final static int DECISION_NODE = 3;
    public final static int ACTIVITY_FINAL_NODE = 4;
    
    /** Creates a new instance. */
    public ActivityModel() {
    }
}